/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.init;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.block.HaystackBlock;
import com.github.mim1q.convenientdecor.block.PitchforkBlock;
import com.github.mim1q.convenientdecor.block.PlushieBlock;
import com.github.mim1q.convenientdecor.block.UmbrellaBlock;
import com.github.mim1q.convenientdecor.block.UmbrellaStandBlock;
import com.github.mim1q.convenientdecor.block.WateringCanBlock;
import com.github.mim1q.convenientdecor.block.WeatherVaneBlock;
import com.github.mim1q.convenientdecor.init.ModSoundEvents;
import com.github.mim1q.convenientdecor.init.group.ColoredGroup;
import java.util.Optional;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.mixin.object.builder.AbstractBlockSettingsAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HayBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.Vec3;

public class ModBlocks {
    public static final PitchforkBlock PITCHFORK = ModBlocks.registerWithSimpleItem(new PitchforkBlock((BlockBehaviour.Properties)ModBlocks.metalSettings().breakInstantly()), "pitchfork");
    public static final WateringCanBlock WATERING_CAN = ModBlocks.register(new WateringCanBlock((BlockBehaviour.Properties)ModBlocks.metalSettings().breakInstantly()), "watering_can");
    public static final HayBlock UNBUNDLED_HAY_BLOCK = ModBlocks.registerWithSimpleItem(new HayBlock(FabricBlockSettings.m_60926_((BlockBehaviour)Blocks.f_50335_)), "unbundled_hay_block");
    public static final HaystackBlock HAYSTACK_BLOCK = ModBlocks.registerLeafPile("haystack_block");
    public static final HaystackBlock LEAF_PILE = ModBlocks.registerLeafPile("leaf_pile");
    public static final HaystackBlock YELLOW_LEAF_PILE = ModBlocks.registerLeafPile("yellow_leaf_pile");
    public static final HaystackBlock ORANGE_LEAF_PILE = ModBlocks.registerLeafPile("orange_leaf_pile");
    public static final HaystackBlock RED_LEAF_PILE = ModBlocks.registerLeafPile("red_leaf_pile");
    public static final HaystackBlock BROWN_LEAF_PILE = ModBlocks.registerLeafPile("brown_leaf_pile");
    public static final HaystackBlock SPRUCE_LEAF_PILE = ModBlocks.registerLeafPile("spruce_leaf_pile");
    public static final HaystackBlock BIRCH_LEAF_PILE = ModBlocks.registerLeafPile("birch_leaf_pile");
    public static final HaystackBlock JUNGLE_LEAF_PILE = ModBlocks.registerLeafPile("jungle_leaf_pile");
    public static final HaystackBlock ACACIA_LEAF_PILE = ModBlocks.registerLeafPile("acacia_leaf_pile");
    public static final HaystackBlock DARK_OAK_LEAF_PILE = ModBlocks.registerLeafPile("dark_oak_leaf_pile");
    public static final HaystackBlock MANGROVE_LEAF_PILE = ModBlocks.registerLeafPile("mangrove_leaf_pile");
    public static final HaystackBlock AZALEA_LEAF_PILE = ModBlocks.registerLeafPile("azalea_leaf_pile");
    public static final HaystackBlock FLOWERING_AZALEA_LEAF_PILE = ModBlocks.registerLeafPile("flowering_azalea_leaf_pile");
    public static final HaystackBlock CHERRY_LEAF_PILE = ModBlocks.registerLeafPile("cherry_leaf_pile");
    public static final PitchforkBlock SHOVEL = ModBlocks.registerWithSimpleItem(new PitchforkBlock((BlockBehaviour.Properties)ModBlocks.metalSettings()), "shovel");
    public static final ColoredGroup.ColoredBlockGroup PLASTIC_SHOVEL = (ColoredGroup.ColoredBlockGroup)((ColoredGroup.ColoredBlockGroup)ColoredGroup.ofBlocks(true).add16Colors(color -> new PitchforkBlock(FabricBlockSettings.m_60926_((BlockBehaviour)SHOVEL)))).register("plastic_shovel");
    public static final ColoredGroup.ColoredBlockGroup UMBRELLA = (ColoredGroup.ColoredBlockGroup)((ColoredGroup.ColoredBlockGroup)ColoredGroup.ofBlocks(false).add16Colors(color -> new UmbrellaBlock((BlockBehaviour.Properties)ModBlocks.metalSettings().breakInstantly().mapColor(color), color))).register("umbrella");
    public static final UmbrellaBlock BROKEN_UMBRELLA = ModBlocks.register(new UmbrellaBlock(FabricBlockSettings.m_60926_((BlockBehaviour)((BlockBehaviour)UMBRELLA.get(DyeColor.RED))), DyeColor.BLACK), "broken_umbrella");
    public static final UmbrellaBlock ALLERTS_UMBRELLA = ModBlocks.register(new UmbrellaBlock(FabricBlockSettings.m_60926_((BlockBehaviour)((BlockBehaviour)UMBRELLA.get(DyeColor.RED))), DyeColor.BLACK), "allerts_umbrella");
    public static final UmbrellaStandBlock UMBRELLA_STAND = ModBlocks.registerWithSimpleItem(new UmbrellaStandBlock((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50075_).breakInstantly()), "umbrella_stand");
    public static final WeatherVaneBlock GOLD_WEATHER_VANE = ModBlocks.registerWithSimpleItem(new WeatherVaneBlock(40, FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50075_).breakInstantly().noCollision().nonOpaque()), "gold_weather_vane");
    public static final WeatherVaneBlock COPPER_WEATHER_VANE = ModBlocks.registerWithSimpleItem(new WeatherVaneBlock(100, FabricBlockSettings.copyOf((BlockBehaviour)GOLD_WEATHER_VANE)), "copper_weather_vane");
    public static final WeatherVaneBlock IRON_WEATHER_VANE = ModBlocks.registerWithSimpleItem(new WeatherVaneBlock(400, FabricBlockSettings.copyOf((BlockBehaviour)GOLD_WEATHER_VANE)), "iron_weather_vane");
    public static final WeatherVaneBlock NETHERITE_WEATHER_VANE = ModBlocks.registerWithSimpleItem(new WeatherVaneBlock(1200, FabricBlockSettings.copyOf((BlockBehaviour)GOLD_WEATHER_VANE)), "netherite_weather_vane");
    public static final PlushieBlock SILLY_ALIEN_PLUSHIE = ModBlocks.registerWithSimpleItem(new PlushieBlock((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50041_).nonOpaque().noCollision(), ModSoundEvents.SILLY_ALIEN_PLUSHIE_SQUISH), "silly_alien_plushie");
    public static final PlushieBlock GNOME_PLUSHIE = ModBlocks.registerWithSimpleItem(new PlushieBlock((BlockBehaviour.Properties)FabricBlockSettings.copyOf((BlockBehaviour)SILLY_ALIEN_PLUSHIE), ModSoundEvents.GNOME_PLUSHIE_SQUISH), "gnome_plushie");

    public static FabricBlockSettings metalSettings() {
        return FabricBlockSettings.create().sounds(SoundType.f_56743_).strength(4.0f, 5.0f);
    }

    public static void init() {
    }

    public static <T extends Block> T registerWithSimpleItem(T block, String name) {
        Registry.m_122965_((Registry)BuiltInRegistries.f_257033_, (ResourceLocation)ConvenientDecor.id(name), (Object)new BlockItem(block, (Item.Properties)new FabricItemSettings()));
        return ModBlocks.register(block, name);
    }

    public static <T extends Block> T register(T block, String name) {
        Registry.m_122965_((Registry)BuiltInRegistries.f_256975_, (ResourceLocation)ConvenientDecor.id(name), block);
        return block;
    }

    private static HaystackBlock registerLeafPile(String name) {
        return ModBlocks.registerWithSimpleItem(new HaystackBlock((BlockBehaviour.Properties)ModBlocks.noZOffset(FabricBlockSettings.copyOf((BlockBehaviour)Blocks.f_50050_).strength(0.2f).sounds(SoundType.f_56740_).noCollision(), true)), name);
    }

    private static FabricBlockSettings noZOffset(FabricBlockSettings settings, boolean additionalOffset) {
        if (additionalOffset) {
            ((AbstractBlockSettingsAccessor)settings).setOffsetter(Optional.of((state, world, pos) -> {
                Block block = state.m_60734_();
                long l = Mth.m_14057_((Vec3i)pos);
                float maxXzOffset = block.m_142740_();
                float maxYOffset = maxXzOffset * block.m_142627_();
                double x = Mth.m_14008_((double)(((double)((float)(l & 0xFL) / 15.0f) - 0.5) * 0.5), (double)(-maxXzOffset), (double)maxXzOffset);
                double y = Mth.m_14008_((double)(((double)((float)(l >> 4 & 0xFL) / 15.0f) - 0.5) * 0.5), (double)(-maxYOffset), (double)maxYOffset);
                double z = Mth.m_14008_((double)(((double)((float)(l >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5), (double)(-maxXzOffset), (double)maxXzOffset);
                Vec3 baseOffset = new Vec3(x, y, z);
                return baseOffset.m_82549_(ModBlocks.getZFightingOffset(pos));
            }));
        } else {
            ((AbstractBlockSettingsAccessor)settings).setOffsetter(Optional.of((state, world, pos) -> ModBlocks.getZFightingOffset(pos)));
        }
        return settings;
    }

    private static Vec3 getZFightingOffset(BlockPos pos) {
        int x = pos.m_123341_() % 3;
        int y = pos.m_123342_() % 3;
        int z = pos.m_123343_() % 3;
        return new Vec3((double)z * 0.001 + (double)y * 5.0E-4 + 5.0E-4, (double)x * 0.001 + (double)z * 5.0E-4 + 5.0E-4, (double)y * 0.001 + (double)x * 5.0E-4 + 5.0E-4);
    }
}

